<?php

class DXOperationPage
{
    public function  __construct()
    {
        require_once(DANCE_X_PLUGIN_PATH . '/includes/evidence-sync.php');

        // Hook for logged-in users
        //Admin Post Actions admin_post_{hidden_action_in_form}
        add_action('admin_post_sync_with_evidence', array($this, 'syncWithEvidence'));
        add_action('admin_post_drop_all_cct_data', array($this, 'dropAllCctData'));
        add_action('admin_post_add_image_to_media_library', array($this, 'addImageToMediaLibrary'));
        add_action('admin_post_do_activity', array($this, 'doActivity'));
    }

    //static -> to init it in plugin-main-class
    public static function operations_html()
    {
        // check user capabilities
        if (!current_user_can('manage_options')) {
            return;
        }

        if (key_exists("notice", $_GET) && key_exists("type", $_GET)) {
            DXUtil::outputWpNotice($_GET['notice'], DXMsgTypeEnum::from($_GET['type']));
        }

?>

        <div class="wrap" id="ev-sync-spinner">
            <h1><?php echo get_admin_page_title(); ?></h1>

            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php?action=sync_with_evidence')); ?>">
                <?php wp_nonce_field('n1'); ?>
                <input type="submit" name="submit_form" class="button button-primary w-100" style="font-size: x-large;" value="Sync with evidence (Drop & Create)">
            </form>

            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php?action=drop_all_cct_data')); ?>">
                <?php wp_nonce_field('n2'); ?>
                <input type="submit" name="submit_form" class="button button-secondary mt-5" style="font-size: large;" value="Delete all synced data" onclick="return confirm('Bist du sicher, das alle synchronisierten Daten gelöscht werden sollen?');">
            </form>

        </div>

<?php
    }

    function syncWithEvidence()
    {
        if (!(key_exists("_wpnonce", $_POST) && wp_verify_nonce($_POST['_wpnonce'], "n1"))) {
            $this->redirectToAdminPage("Nonce invalid!", "error");
            exit;
        }

        $syncer = new DXEvidenceSync();
        $result = $syncer->processSync();

        if ($result) {
            $this->redirectToAdminPage("Sync successfully done.", "success");
        } else {
            $this->redirectToAdminPage("Sync failed!", "error");
        }

        exit;
    }

    function dropAllCctData()
    {
        $da = new DXDataAccess();
        $result = $da->cleanupDatabaseFromDanceXData();

        if ($result) {
            $this->redirectToAdminPage("Delete all synced data done.", "success");
        } else {
            $this->redirectToAdminPage("Something went wrong...", "error");
        }

        exit;
    }

    function addImageToMediaLibrary()
    {
        if (!(key_exists("_wpnonce", $_POST) && wp_verify_nonce($_POST['_wpnonce'], "n2"))) {
            $this->redirectToAdminPage("Nonce invalid!", "error");
            exit;
        }

        $base64Image = file_get_contents(DANCE_X_PLUGIN_PATH . "base64Img.txt");
        DXUtil::importImageToMediaLibrary($base64Image);

        $this->redirectToAdminPage("Image added.", "success");

        exit;
    }

    function doActivity()
    {
        if (!(key_exists("_wpnonce", $_POST) && wp_verify_nonce($_POST['_wpnonce'], "n3"))) {
            $this->redirectToAdminPage("Nonce invalid!", "error");
            exit;
        }

        try {

            //add code here to do some stuff

            $this->redirectToAdminPage("Ok: Keine Aktivität definiert ...", "info");
        } catch (\Throwable $th) {
            $this->redirectToAdminPage("Ex happended: " . $th->getMessage(), "error");
        }
        exit;
    }

    function redirectToAdminPage($notice, $type)
    {
        $encodedNotice = urlencode($notice);
        wp_redirect(admin_url("admin.php?page=dxcp_operations&notice=$encodedNotice&type=$type"));
    }
}

$dxOperationPage = new DXOperationPage();
