function loadQuote(figure, catChooser) {
  let selectedCategory = catChooser.val();

  jQuery.ajax({
    url: dxcp_admin_script_data.rest_api_quote_url + `?cat=${selectedCategory}`,
    type: "GET",
    data: {
      nonce: dxcp_admin_script_data.nonce,
    },
    success: function (quote) {
      figure.find("#qquote").text(quote.quote);
      figure.find("#qauthor").text(quote.author);
      figure.find("#qcategory").text(`(${quote.category})`);
    },
    error: function (xhr, status, error) {
      console.error(`XHR: ${xhr} | Status: ${status} | Error: ${error}`);
    },
  });
}

function displayLoadingUi(question) {
  if (question) {
    let answer = confirm(question);
    if (answer) {
      document.querySelector(".loader-block-overlay").style.display = "block";
      return true;
    }
  } else {
    document.querySelector(".loader-block-overlay").style.display = "block";
    return true;
  }

  return false;
}
