<?php

/**
 * Contains all used table names of the plugin. The listed table-names are not prefixed.
 */
class DXCctTableEnum
{
    const  WpPosts = 'posts';

    const  JetPostTypes = 'jet_post_types';
    const  JetRelDefault = 'jet_rel_default';
    const  JetRelDefaultMeta = 'jet_rel_default_meta';

    const  CctKurs = 'jet_cct_dxt_kurs';
    const  CctKursgruppe = 'jet_cct_dxt_kursgruppe';
    const  CctKurstyp = 'jet_cct_dxt_kurstyp';
    const  CctKursstufe = 'jet_cct_dxt_kursstufe';
    const  CctKursleiter = 'jet_cct_dxt_kursleiter';
    const  CctEvent = 'jet_cct_dxt_event';
    const  CctMenu = 'jet_cct_dxt_menu';
    const  CctKursperiode = 'jet_cct_dxt_kursperiode';

    public static function wpdb_prefix(string $dxCctTableEnum): string
    {
        global $wpdb;
        $prefixedTable = $wpdb->prefix . $dxCctTableEnum;

        return $prefixedTable;
    }

    public static function getCctTablesWithCctSinglePostIds(): array
    {
        $result = array();

        $types = DXType::GetAllTypes();
        foreach ($types as $type) {
            if ($type->hasSinglePost && $type->cleanSinglePostsOnUpdate) {
                $result[] = DXCctTableEnum::wpdb_prefix($type->dxCctTableEnum);
            }
        }

        return $result;
    }
}

/**
 * Contains all CCT-Types of the plugin.
 */
class DXTypeEnum
{
    const Kurs = 'Kurs';
    const Kursleiter = 'Kursleiter';
    const Kursstufe = 'Kursstufe';
    const Kurstyp = 'Kurstyp';
    const Kursgruppe = 'Kursgruppe';
    const Event = 'Event';
    const Menu = 'Menu';
    const Kursperiode = 'Kursperiode';
}

/**
 * Message-types.
 */
class DXMsgTypeEnum
{
    const Error = 'error';
    const Warning = 'warning';
    const Success = 'success';
    const Info = 'info';
}

class DXRestOptions
{
    public string $endpoint;
    public string $apiKey;

    public string $endpointV2;
    public string $apiKeyV2;
}

class DXType
{
    public string $dxTypeEnum;
    public string $dxCctTableEnum;
    public bool $hasSinglePost;
    public bool $cleanSinglePostsOnUpdate;

    public string $cptDisplayName;
    public string $cptTypeName;

    public function __construct(string $dxTypeEnum, string $dxCctTableEnum, bool $hasSinglePost, bool $cleanSinglePostsOnUpdate)
    {
        $cptDisplayPraefix = "CPT_";
        $cptTypeNamePraefix = "dx";

        $typeNameLowered = strtolower($dxTypeEnum);

        $this->dxTypeEnum = $dxTypeEnum;
        $this->dxCctTableEnum = $dxCctTableEnum;
        $this->hasSinglePost = $hasSinglePost;
        $this->cleanSinglePostsOnUpdate = $cleanSinglePostsOnUpdate;

        $this->cptDisplayName = "{$cptDisplayPraefix}{$dxTypeEnum}";
        $this->cptTypeName = "{$cptTypeNamePraefix}{$typeNameLowered}";
    }

    public static function GetAllTypes(): array
    {
        $types = array();

        $types[] = new DXType(DXTypeEnum::Kurs, DXCctTableEnum::CctKurs, true, true);
        $types[] = new DXType(DXTypeEnum::Event, DXCctTableEnum::CctEvent, true, true);
        $types[] = new DXType(DXTypeEnum::Menu, DXCctTableEnum::CctMenu, true, true);
        $types[] = new DXType(DXTypeEnum::Kursleiter, DXCctTableEnum::CctKursleiter, true, true);

        $types[] = new DXType(DXTypeEnum::Kursstufe, DXCctTableEnum::CctKursstufe, false, false);
        $types[] = new DXType(DXTypeEnum::Kurstyp, DXCctTableEnum::CctKurstyp, false, false);
        $types[] = new DXType(DXTypeEnum::Kursgruppe, DXCctTableEnum::CctKursgruppe, false, false);
        $types[] = new DXType(DXTypeEnum::Kursperiode, DXCctTableEnum::CctKursperiode, false, false);

        return $types;
    }

    public static function GetType(string $dxTypeEnum): DXType
    {
        $types = DXType::GetAllTypes();

        $arr = array_filter($types, function ($item) use ($dxTypeEnum) {
            if ($item->dxTypeEnum == $dxTypeEnum) {
                return true;
            }
        });

        if (count($arr) == 1)
            //array_filter keeps the IDs of the array *facePalm*
            return reset($arr);

        return null;
    }
}
