<?php

class DXJetFormBuilderLogic
{
    public function  __construct()
    {
        add_action('jet-form-builder/custom-action/kursanmeldung', array($this, 'kursanmeldung_action'), 10, 2);
    }

    function kursanmeldung_action($request, $handler)
    {
        $requestObject = array();
        $backendComm = new DXBackendCommunication();

        try {

            $agb = $request['agb'];
            if (!$agb)
                throw new Exception("Die AGB's wurden nicht akzeptiert!");

            $personCount = null;
            $regulierer =  null;

            $anmelden_als = $request['anmelden_als'];
            $copy_address_from_p1_to_p2 = !is_null($request['copy_address_from_p1_to_p2']) && $request['copy_address_from_p1_to_p2'] == 'on';

            //bei der Paaranmeldung gibt es 2xPersonendaten + die Angaben wer die Rechnung bezahlt
            if ($anmelden_als == 'single') {
                $personCount = 1;
                $regulierer = 'IchZahle';
            } else if ($anmelden_als == 'paar') {
                $personCount = 2;
                $regulierer =  $request['regulierer'];
            } else {
                throw new Exception("Der übergebene Wert von 'anmelden_als' ist nicht bekannt: " + $anmelden_als);
            }

            $requestObject['Kursnummer'] = $request['kursnummer'];
            $requestObject['Bemerkung'] = $request['bemerkung'];

            //why is this needed - take it from CCT ???
            $requestObject['Kleinkassenzuschlag'] = true;
            $requestObject['Regulierer'] = $regulierer;

            //todo: überprüfung der maximal Teilnehmer auf dem Kurs
            //vllt. braucht es die CCT-ID, damit ich alle Meta-daten abfragen kann
            //können sich 2xMänner bzw. 2xFrauen anmelden und es wird überprüft, ob das so noch frei ist
            //-> bei der Anmeldung am Backend wird nix überprüft, ob jemand bereits angemeldet ist / die Web-Anmeldungen werden immer aufgenommen

            for ($pid = 1; $pid <= $personCount; $pid++) {

                if ($pid == 1) {
                    $personData1 = $this->getPersonData($request, $pid, $copy_address_from_p1_to_p2);
                    $requestObject = array_merge($requestObject, $personData1);
                } else if ($pid == 2) {
                    $personData2 =  $this->getPersonData($request, $pid, $copy_address_from_p1_to_p2);

                    if ($copy_address_from_p1_to_p2) {
                        $personData2['Strasse'] = $requestObject['Strasse'];
                        $personData2['HausNr'] = $requestObject['HausNr'];
                        $personData2['PLZ'] = $requestObject['PLZ'];
                        $personData2['Ort'] = $requestObject['Ort'];
                    }

                    $requestObject['Tanzpartner'] = $personData2;
                } else {
                    throw new Exception("Kursanmeldung of person count {$pid} is not implemented!");
                }
            }

            //just log data for easier debugging
            error_log("KursAnmeldung-Array (vor dem Senden zum Backend): " . serialize($requestObject));

            $result = $backendComm->kursAnmeldung($requestObject);
            if (!$result) {
                throw new Exception("Die Kursanmeldung am Backend hat nicht funktioniert.");
            }
        } catch (\Throwable $th) {
            error_log("Bei der internen Verarbeitung des Formulars ist ein Fehler aufgetreten:" . $th->getMessage());
            throw new \Jet_Form_Builder\Exceptions\Action_Exception('Bei der internen Verarbeitung des Formulars ist ein Fehler aufgetreten.');
        }
    }

    function getPersonData($request, $pid, $copy_address_from_p1_to_p2)
    {
        $result = array();

        $personKeys = array(
            "email",
            "anrede",
            "titel",
            "vorname",
            "nachname",
            "geburtsdatum",
            "korpergrosse_in_cm",
            "telefon",
            "mobil",
            "strasse",
            "hausnr",
            "plz",
            "ort",
            "student"
        );

        foreach ($personKeys as $personKey) {

            //if Person 
            $calculatedRequiredFlag = $pid == 1 || ($pid == 2 && !$copy_address_from_p1_to_p2);

            switch ($personKey) {
                case 'email':
                    $result['Email'] = $this->getRequestData("{$personKey}_{$pid}", $request, true);
                    break;

                case 'anrede':
                    $result['Anrede'] = $this->getRequestData("{$personKey}_{$pid}", $request, true);
                    break;

                case 'titel':
                    $result['Titel'] = $this->getRequestData("{$personKey}_{$pid}", $request, false);
                    break;

                case 'vorname':
                    $result['Vorname'] =  $this->getRequestData("{$personKey}_{$pid}", $request, true);
                    break;

                case 'nachname':
                    $result['Name'] = $this->getRequestData("{$personKey}_{$pid}", $request, true);
                    break;

                case 'geburtsdatum':
                    $result['Geburtsdatum'] = $this->getRequestData("{$personKey}_{$pid}", $request, false);
                    break;

                case 'korpergrosse_in_cm':
                    $result['Koerpergroesse'] = $this->getRequestData("{$personKey}_{$pid}", $request, false);
                    break;

                case 'telefon':
                    $result['TelefonFestNetz'] = $this->getRequestData("{$personKey}_{$pid}", $request, false);
                    break;

                case 'mobil':
                    $result['TelefonMobile'] = $this->getRequestData("{$personKey}_{$pid}", $request, true);
                    break;

                case 'strasse':
                    $result['Strasse'] = $this->getRequestData("{$personKey}_{$pid}", $request, $calculatedRequiredFlag);
                    break;

                case 'hausnr':
                    $result['HausNr'] = $this->getRequestData("{$personKey}_{$pid}", $request, false);
                    break;

                case 'plz':
                    $result['PLZ'] = $this->getRequestData("{$personKey}_{$pid}", $request, $calculatedRequiredFlag);
                    break;

                case 'ort':
                    $result['Ort'] = $this->getRequestData("{$personKey}_{$pid}", $request, $calculatedRequiredFlag);
                    break;

                case 'student':
                    //because unchecked check-boxes are not sent by browser we have to specifically handle this case here
                    $result['Student'] = false;
                    $student = $this->getRequestData("{$personKey}_{$pid}", $request, false);
                    if ($student != null) {
                        $result['Student'] = true;
                    }
                    break;

                default:
                    throw new Exception("The mapping of key {$personKey} is not implemented!");
            }
        }

        return $result;
    }

    function getRequestData(string $key, array $request, bool $isRequired)
    {
        $result = null;

        if (array_key_exists($key, $request)) {
            $result = $request[$key];
        }

        if ($isRequired && $result == null) {
            throw new Exception("The required key {$key} was not part of the request-data or it's data was null!");
        }

        return $result;
    }
}

$dxJetFormBuilderLogic = new DXJetFormBuilderLogic();
