<?php

use Carbon_Fields\Container;
use Carbon_Fields\Field;

class DXOptionsPage
{
    public function  __construct()
    {
        add_action('after_setup_theme', array($this, 'crb_load'));
        add_action('carbon_fields_register_fields', array($this, 'create_options_page'));
    }

    function crb_load()
    {
        \Carbon_Fields\Carbon_Fields::boot();
    }

    function create_options_page()
    {
        //https://docs.carbonfields.net/learn

            // Default options page
            $basic_options_container = Container::make('theme_options', 'Einstellungen')
                ->set_page_parent("dxcp_menu")
                ->set_page_menu_title('Einstellungen')
                ->add_tab('Allgemein', [
                    Field::make('text', 'dxcp_rest_endpoint', 'REST Endpoint V1')->set_required(true),
                    Field::make('text', 'dxcp_apikey', 'ApiKey V1')->set_required(true),

                    Field::make('text', 'dxcp_rest_endpoint_v2', 'REST Endpoint V2')->set_required(true),
                    Field::make('text', 'dxcp_apikey_v2', 'ApiKey V2')->set_required(true),

                    Field::make('checkbox', 'dxcp_show_cpt', 'CPT-Menüs in Navigation anzeigen?')->set_required(false),
                    Field::make('checkbox', 'dxcp_update_kursbelegung', 'Automatisch (bei Navigation auf die Kurs-Detail-Seite) Kurs-Belegung updaten?')
                        ->set_help_text("Verursacht mehr Anfragen/Requests an das Dance-X-Backend")
                        ->set_required(false)
                ])
                ->add_Tab('Update-Cron-Job', [
                    Field::make('checkbox', 'dxcp_update_cronjob_enabled', 'Update-Cron-Job für regelmässigen Datenabgleich mit DanceX-Backend aktivieren?')
                        ->set_help_text('Wenn diese Option aktiviert wird, dann sollte ein "echter Cron-Job" eingerichtet werden, der regelmässig "wp-cron.php" aufruft (vgl. "https://www.cyon.ch/support/a/wordpress-cron-deaktivieren"). Wenn dies nicht gemacht wird, handelt es sich bei allen Cron-Jobs nur um "Pseudo-Cron-Jobs", die an die Nutzungsfrequenz der Website gebunden sind. Dies kann dazu führen, das Jobs nicht ausgeführt werden, obwohl der Ausführungszeitpunkt bereits verstrichen ist!')
                        ->set_required(false),


                Field::make('select', 'dxcp_update_cronjob_run_every_minute', 'Update-Cron-Job Intervall')
                    ->add_options(array(
                        '' =>   '--- Auswahl ---',
                        1 => 'alle Minute',
                        5 => 'alle 5 Minuten',
                        10 => 'alle 10 Minuten',
                        30 => 'alle 30 Minuten',
                        60 => 'alle 60 Minuten',
                        720 => 'alle 12 Stunden',
                        1440 => 'alle 24 Stunden'
                    ))
                    ->set_conditional_logic(array(array(
                        'field' => 'dxcp_update_cronjob_enabled',
                        'value' => true
                    )))
                    ->set_help_text('Info: sehr gutes Plugin, um Cron-Einstellungen zu überprüfen: "WP Crontrol"')
                    ->set_required(true),

                Field::make('date_time', 'dxcp_update_cronjob_starttime', 'optionaler Startzeitpunkt (in UTC)')
                    ->set_conditional_logic(array(array(
                        'field' => 'dxcp_update_cronjob_enabled',
                        'value' => true
                    )))
                    ->set_help_text('wenn der Wert nicht angegeben wird, dann wird als Startzeit der aktuelle Unix-Timestamp (PHP-Funktion time()) verwendet.')
                    ->set_required(false)
            ]);
    }
}

$dxOptionsPage = new DXOptionsPage();
