
CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_event` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_single_post_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,
  
  `eventnummer` text DEFAULT NULL,
  `titel` text DEFAULT NULL,
  `beschreibung` longtext DEFAULT NULL,
  `ort` text DEFAULT NULL,
  `vorverkaufspreis` decimal(12,2) DEFAULT NULL,
  `abendkasse` decimal(12,2) DEFAULT NULL,
  `von` text DEFAULT NULL,
  `kategorie` text DEFAULT NULL,
  `datum` text DEFAULT NULL,
  `adresse` text DEFAULT NULL,
  `link` text DEFAULT NULL,
  `bis` text DEFAULT NULL,
  `flyer_dateiname` text DEFAULT NULL,
  `flyer_dokumentid` text DEFAULT NULL,
  `flyer_bildid` text DEFAULT NULL,
  `flyer_dokument` bigint(20) DEFAULT NULL,
  `flyer_bild` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_kurs` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_single_post_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,

  `kursleiter` text DEFAULT NULL,
  `kursleiter_vorname` text DEFAULT NULL,
  `kursleiter_nachname` text DEFAULT NULL,
  `fkkursgruppe` bigint(20) DEFAULT NULL,
  `kursgruppe` text DEFAULT NULL,
  `fkkurstyp` bigint(20) DEFAULT NULL,
  `kurstyp` text DEFAULT NULL,
  `fkkursstufe` bigint(20) DEFAULT NULL,
  `kursstufe` text DEFAULT NULL,
  `sortierung` bigint(20) DEFAULT NULL,
  `preis` decimal(12,2) DEFAULT NULL,
  `kleinklassenzuschlag` decimal(12,2) DEFAULT NULL,
  `minimumteilnehmerkleinklasse` bigint(20) DEFAULT NULL,
  `singleanmeldungzwingend` text DEFAULT NULL,
  `paaranmeldungzwingend` text DEFAULT NULL,
  `paartanz` text DEFAULT NULL,
  `paarrabatt` decimal(12,2) DEFAULT NULL,
  `schuelerstudentenrabatt` decimal(12,2) DEFAULT NULL,
  `viprabatt` decimal(12,2) DEFAULT NULL,
  `wiederholungsrabatt` decimal(12,2) DEFAULT NULL,
  `kursanmeldungstopvoll` text DEFAULT NULL,
  `kursnummer` text DEFAULT NULL,
  `name` text DEFAULT NULL,
  `kurzzeichen` text DEFAULT NULL,
  `freieplaetzemann` bigint(20) DEFAULT NULL,
  `freieplaetzefrau` bigint(20) DEFAULT NULL,
  `freieplaetze` bigint(20) DEFAULT NULL,
  `anzahllektionen` bigint(20) DEFAULT NULL,
  `ersterkurstag` text DEFAULT NULL,
  `letzterkurstag` text DEFAULT NULL,
  `kursdatenauflistung` text DEFAULT NULL,
  `kurstageauflistung` text DEFAULT NULL,
  `kursdaten` longtext DEFAULT NULL,
  `kursleiterids` longtext DEFAULT NULL,
  `kursleiter_objectids` longtext DEFAULT NULL,
  `kursperiode` bigint(20) DEFAULT NULL,
  `blockdauerdisplay` text DEFAULT NULL,
  `blockzeitendisplay` text DEFAULT NULL,
  `ctafliesstext` longtext DEFAULT NULL,
  `kurswebtext` longtext DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_kursgruppe` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,

  `kurzzeichen` text DEFAULT NULL,
  `name` text DEFAULT NULL,
  `webtext` longtext DEFAULT NULL,
  `teasertext` longtext DEFAULT NULL,
  `sortierung` bigint(20) DEFAULT NULL,
  `webfiltera` text DEFAULT NULL,
  `webfilterb` text DEFAULT NULL,
  `bild` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_kursleiter` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_single_post_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,

  `id` text DEFAULT NULL,
  `name` text DEFAULT NULL,
  `vorname` text DEFAULT NULL,
  `funktion` text DEFAULT NULL,
  `webtext` longtext DEFAULT NULL,
  `sortierung` bigint(20) DEFAULT NULL,
  `foto` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_kursstufe` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,

  `kurzzeichen` text DEFAULT NULL,
  `name` text DEFAULT NULL,
  `webtext` longtext DEFAULT NULL,
  `sortierung` bigint(20) DEFAULT NULL,
  `top4` text DEFAULT NULL,
  `teasertext` longtext DEFAULT NULL,
  `bild` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_kurstyp` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,

  `kurzzeichen` text DEFAULT NULL,
  `name` text DEFAULT NULL,
  `webtext` longtext DEFAULT NULL,
  `sortierung` bigint(20) DEFAULT NULL,
  `top4` text DEFAULT NULL,
  `bild` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_menu` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_single_post_id` bigint(20) DEFAULT NULL,

  `objectid` bigint(20) DEFAULT NULL,
  `geaendertam` text DEFAULT NULL,

  `mainmenu` text DEFAULT NULL,
  `submenu` text DEFAULT NULL,
  `sortierung` bigint(20) DEFAULT NULL,
  `nesting_level_1` text DEFAULT NULL,
  `nesting_level_2` text DEFAULT NULL,
  `nesting_level_3` text DEFAULT NULL,
  `nesting_level_4` text DEFAULT NULL,
  `filter_kursgruppe` longtext DEFAULT NULL,
  `filter_kursstufe` longtext DEFAULT NULL,
  `filter_kurstyp` longtext DEFAULT NULL,
  `filter_kursleiter` longtext DEFAULT NULL,
  `show_nesting_level_1` text DEFAULT NULL,
  `show_nesting_level_2` text DEFAULT NULL,
  `show_nesting_level_3` text DEFAULT NULL,
  `show_nesting_level_4` text DEFAULT NULL,
  `filter_kursperiode` longtext DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_cct_dxt_kursperiode` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cct_author_id` bigint(20) DEFAULT NULL,

  `kursperiode` bigint(20) DEFAULT NULL,
  `startkursperiodemonat` text DEFAULT NULL,
  `startkursperiodemonatzahl` bigint(20) DEFAULT NULL,
  `startkursperiodejahr` bigint(20) DEFAULT NULL,
  `endekursperiodemonat` text DEFAULT NULL,
  `endekursperiodemonatzahl` bigint(20) DEFAULT NULL,
  `endekursperiodejahr` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_rel_default` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `created` timestamp NULL DEFAULT current_timestamp(),
  `rel_id` text DEFAULT NULL,
  `parent_rel` int(11) DEFAULT NULL,
  `parent_object_id` bigint(20) DEFAULT NULL,
  `child_object_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


CREATE TABLE IF NOT EXISTS `{WPTablePrefix}jet_rel_default_meta` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `created` timestamp NULL DEFAULT current_timestamp(),
  `rel_id` text DEFAULT NULL,
  `parent_object_id` bigint(20) DEFAULT NULL,
  `child_object_id` bigint(20) DEFAULT NULL,
  `meta_key` text DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;